#!/bin/sh

FAIL=0

error() {
	echo "ERROR: $1" >&2 && FAIL=1
}

whoami | grep root > /dev/null     && error "This script should not be run as root."
! grep -q "sse4_2" /proc/cpuinfo   && error "CPU is missing support for SSE4.2 instruction set."
! which dbus-send > /dev/null      && error "Missing required dependency 'dbus-send'."

XDG_PORTAL_FILECHOOSER_VERSION=$(dbus-send --session --print-reply=literal --dest=org.freedesktop.portal.Desktop --type=method_call /org/freedesktop/portal/desktop org.freedesktop.DBus.Properties.Get string:org.freedesktop.portal.FileChooser string:version)
XDG_PORTAL_FILECHOOSER_VERSION=$(echo "$XDG_PORTAL_FILECHOOSER_VERSION" | awk '{print $3}')
if [ "$XDG_PORTAL_FILECHOOSER_VERSION" -lt 2 ]; then
	error "org.freedesktop.portal.FileChooser version $XDG_PORTAL_FILECHOOSER_VERSION too old, need version 2"
fi

LIBS=$(/sbin/ldconfig -p)
! echo "$LIBS" | grep -q "libxcb.so.1" && error "Missing required library dependency libxcb."
! echo "$LIBS" | grep -q "libxcb-keysyms.so.1" && error "Missing required library dependency libxcb-keysyms."
! echo "$LIBS" | grep -q "libxcb-shm.so.0" && error "Missing required library dependency libxcb-shm."
! echo "$LIBS" | grep -q "libsystemd.so.0" && error "Missing required library dependency libsystemd."

if [ "$FAIL" -eq 0 ]; then
	echo "SUCCESS: No compatibility issues found"
else
	echo "FAILED: Compatibility issues found" >&2
fi

exit $FAIL
